try:
    import pygame
except ImportError:
    pygame = None

black    = (   0,   0,   0)
white    = ( 255, 255, 255)
green    = (   0, 100,   0)
orange = (255, 165, 0)
maroon      = ( 100,   0,   0)
red = (255, 0, 0 )
blue    = ( 0, 0, 255 )
yellow = (255, 255, 0)
pink = (255,20,147)

import random
import math
import numpy
size = [1200,1200]
sensors = 3

class Swarm:

    num = 0
    def __init__(self,size,wts):
        self.bots = []
        for i in range(size):
            Swarm.num += 1
            self.bots.append(Bot(Swarm.num,wts))
        self.size = size
        self.kills = 0
        self.enemies_found = 0
        self.total_dist = 0.0
        self.dist = 0.0

    def update(self,objects,screen='NULL'):
        self.dist = 0.0
        size = self.size
        for b in self.bots:
            b.update(objects,screen)
        self.total_dist += (self.dist / float(size))
##        print self.total_dist

    def draw(self,screen):
        for b in self.bots:
            b.draw(screen)

    def check_deaths(self):
        for n, b in enumerate(reversed(self.bots)):
            if b.h <= 0:
                del self.bots[len(self.bots)-n-1]

    def count(self):
        total = 0.0
        num_in_bounds = 0.0
        percent_in_bounds = 0.0
        max_limit = math.sqrt((size[0]//2)**2+(size[1]//2)**2)
        for b in self.bots:
            total += 1
            mid_x = size[0]//2
            mid_y = size[1]//2
            d = math.sqrt(((mid_x-b.x)**2)+((mid_y-b.y)**2))
            if d < max_limit:
                num_in_bounds += 1
        if total > 0:
            percent_in_bounds = num_in_bounds/total
        else:
            precent_in_bounds = 1.0
        return round(percent_in_bounds,2)
            

class Bot:

    def __init__(self,num,wts):
        
##        (self.close_wt, self.target_wt, self.enemy_wt) = wts
        self.task = 0#random.randint(0,1) #Task 0:defend, Task 1:attack
        self.num = num
        self.max_x = size[0]
        self.max_y = size[1]
        self.r = 6
        self.h = 100
##        self.x = size[0] / 2
##        self.y = size[1] / 2
        self.x = random.randint(size[0]//2-50,size[0]//2+50)
        self.y = random.randint(size[1]//2-50,size[1]//2+50)
        self.dx = 0
        self.dy = 0
        self.isAlive = True
        self.previousX = [self.x,self.x,self.x]
        self.previousY = [self.y,self.y,self.y]
        self.w = wts
        self.enemyFound = False
        self.enemyX = 0.0
        self.enemyY = 0.0
        self.defendersSeen = []
##        self.recruiting = False

    def closest_bot_wt(self,d,task,sensor_range):
        h = float(sensor_range//2)
        if task == 0:
            if d < h:
                return (((self.w[1]-self.w[0])/h)*d + self.w[0],((self.w[4]-self.w[3])/h)*d + self.w[3])
            else:
                return (((self.w[2]-self.w[1])/h)*(d-h) + self.w[1],((self.w[5]-self.w[4])/h)*(d-h) + self.w[4])
        elif task == 1 and not self.enemyFound:
            if d < sensor_range//2:
                return (((self.w[7]-self.w[6])/h)*d + self.w[6],((self.w[10]-self.w[9])/h)*d + self.w[9])
            else:
                return (((self.w[8]-self.w[7])/h)*(d-h) + self.w[7],((self.w[11]-self.w[10])/h)*(d-h) + self.w[10])
        else:
            if d < sensor_range//2:
                return (((self.w[13]-self.w[12])/h)*d + self.w[12],((self.w[16]-self.w[15])/h)*d + self.w[15])
            else:
                return (((self.w[14]-self.w[13])/h)*(d-h) + self.w[13],((self.w[17]-self.w[16])/h)*(d-h) + self.w[16])

    def bot_knows(self,d,sensor_range):
        h = float(sensor_range//2)
##        if self.enemyFound:
##        (x,y) = e_id
##        self.enemyX = x
##        self.enemyY = y
##            if x == self.enemyX and y == self.enemyY:
        if d < h:
            return (((self.w[52]-self.w[51])/h)*d + self.w[51],((self.w[55]-self.w[54])/h)*d + self.w[54])
        else:
            return (((self.w[53]-self.w[52])/h)*(d-h) + self.w[52],((self.w[56]-self.w[55])/h)*(d-h) + self.w[55])
##            else:
##                if d < h:
##                    return (((self.w[65]-self.w[64])/h)*d + self.w[64],((self.w[68]-self.w[67])/h)*d + self.w[67])
##                else:
##                    return (((self.w[66]-self.w[65])/h)*(d-h) + self.w[65],((self.w[69]-self.w[68])/h)*(d-h) + self.w[68])
##        else:
##            if d < h:
##                return (((self.w[58]-self.w[57])/h)*d + self.w[57],((self.w[61]-self.w[60])/h)*d + self.w[60])
##            else:
##                return (((self.w[59]-self.w[58])/h)*(d-h) + self.w[58],((self.w[62]-self.w[61])/h)*(d-h) + self.w[61])
            

    def target_wt(self,d,task,sensor_range):
        h = float(sensor_range//2)
        if task == 0:
##            h = self.w[74]
            if d < h:
                return (((self.w[19]-self.w[18])/h)*d + self.w[18],((self.w[22]-self.w[21])/h)*d + self.w[21])
            else:
                return (((self.w[20]-self.w[19])/h)*(d-h) + self.w[19],((self.w[23]-self.w[22])/h)*(d-h) + self.w[22])
        elif task == 1:
##            h = self.w[75]
            if d < h:
                return (((self.w[25]-self.w[24])/h)*d + self.w[24],((self.w[28]-self.w[27])/h)*d + self.w[27])
            else:
                return (((self.w[26]-self.w[25])/h)*(d-h) + self.w[25],((self.w[29]-self.w[28])/h)*(d-h) + self.w[28])
            
    def center(self,d,task):
        if task == 0:
            h = float(self.w[63])
            if d < h:
                return 0
            else:
                return min((self.w[48]/h)*(d-h),6)             
        elif task == 1 and self.enemyFound:
            h = float(self.w[64])
            if d < h:
                return 0
            else:
                return min((self.w[49]/h)*(d-h),6)
        else:
            h = float(self.w[65])
            if d < h:
                return 0
            else:
                return min((self.w[50]/h)*(d-h),6)

    def enemy_wt(self,d,task,sensor_range):
        h = float(sensor_range//2)
        if d < h:
            return (((self.w[31]-self.w[30])/h)*d + self.w[30],((self.w[34]-self.w[33])/h)*d + self.w[33])
        else:
            return (((self.w[32]-self.w[31])/h)*(d-h) + self.w[31],((self.w[35]-self.w[34])/h)*(d-h) + self.w[34])
##                print result, self.w[30:33], h, d
                
    def group(self,n,max_size):
##        h = max_size//2
        h = float(self.w[60])
##        print h
        if n < h:
            return (((self.w[43]-self.w[42])/h)*n + self.w[42],((self.w[46]-self.w[45])/h)*n + self.w[45])
        else:
##            return (self.w[54],self.w[57])
            return (((self.w[44]-self.w[43])/h)*(n-h) + self.w[43],((self.w[47]-self.w[46])/h)*(n-h) + self.w[46])

    def torpedo_wt(self,d,task,sensor_range):
        h = float(sensor_range//2)
        if d < h:
            return (((self.w[37]-self.w[36])/h)*d + self.w[36],((self.w[40]-self.w[39])/h)*d + self.w[39])
        else:
            return (((self.w[38]-self.w[37])/h)*(d-h) + self.w[37],((self.w[41]-self.w[40])/h)*(d-h) + self.w[40])
    
            

    def update(self,objects,screen='NULL'):
##        print len(self.w)
        dist = 0.0

##        print self.num

        (s,e,t) = objects
        self.dx += random.uniform(-1,0) + random.uniform(0,1)
        self.dy += random.uniform(-1,0) + random.uniform(0,1)

##        if self.task == 0: # Defensive mode
        self.recruiting = False
        botsSeenSame = 0
        botsSeenDif = 0
        botKnows = False
        closestBotKnows = 40
        botKnowsX = 0.0
        botKnowsY = 0.0
##        botKnowsId = (0,0)
        # Closest bot sensor
        sensor_range = 40
        closest_d = sensor_range
        closest = 0
        botsInRange = False
        self.signal_heard = False
        centroid_x = 0.0
        centroid_y = 0.0
        for b in s.bots:
            d = math.sqrt(((b.x-self.x)**2)+((b.y-self.y)**2))
            if d < sensor_range and d > 0:
                if b.task == self.task:
                    botsSeenSame += 1
                    botsInRange = True
                    centroid_x += b.x
                    centroid_y += b.y
                    if d < closest_d:
                        closest = b.num
                        closest_d = d
                        x = b.x
                        y = b.y
                    if b.enemyFound:
                        self.enemyFound = False
                        botKnows = True
                        if d < closestBotKnows:
                            closestBotKnows = d
                            botKnowsX = b.x
                            botKnowsY = b.y
##                            botKnowsId = (b.enemyX,b.enemyY)
                else:
                    botsSeenDif += 1
                    if b.signal:
                        self.signal_heard = True
        if self.task == 0:
            self.defendersSeen.append(botsSeenSame)
        else:
            self.defendersSeen.append(botsSeenDif)
##        if len(self.defendersSeen) > self.w[78]: # Evolve the 5 parameter!
##            self.defendersSeen.pop()
##        if self.task == 0 and numpy.average(self.defendersSeen) < self.w[80]: # Evolve the 2 parameter!
##            self.recruiting = True
        
##        close_wt = -4
##        if botsInRange:
##            (to,pl) = self.closest_bot_wt(closest_d,self.task,sensor_range)
####            pygame.draw.line(screen,pink,[self.x,self.y],[x,y],2)
##            self.dx += float(to) * (x-self.x) / closest_d
##            self.dy += float(to) * (y-self.y) / closest_d
##            self.dx += float(pl) * (y-self.y) / closest_d
##            self.dy -= float(pl) * (x-self.x) / closest_d
        # version with centroid
        if botsInRange:
            centroid_x /= float(botsSeenSame)
            centroid_y /= float(botsSeenSame)
            cent_dist = math.sqrt(((centroid_x-self.x)**2)+((centroid_y-self.y)**2))
            if cent_dist > 0:
                (to,pl) = self.closest_bot_wt(cent_dist,self.task,sensor_range)
                self.dx += float(to) * (centroid_x-self.x) / cent_dist
                self.dy += float(to) * (centroid_y-self.y) / cent_dist
                self.dx += float(pl) * (centroid_y-self.y) / cent_dist
                self.dy -= float(pl) * (centroid_x-self.x) / cent_dist
            

        # Target sensor
        targetSeen = False
        d = math.sqrt(((t.x-self.x)**2)+((t.y-self.y)**2))
        sensor_range = 100
        if d > 0:
            if d < sensor_range:# or self.task == 0 or self.task == 1:
                targetSeen = True
        if targetSeen:
            (to,pl) = self.target_wt(d,self.task,sensor_range)
##                pygame.draw.line(screen,white,[self.x,self.y],[t.x,t.y],2)
            self.dx += float(to) * (t.x-self.x) / d
            self.dy += float(to) * (t.y-self.y) / d
            self.dx += float(pl) * (t.y-self.y) / d
            self.dy -= float(pl) * (t.x-self.x) / d

        # Center sensor
        mid_x = size[0]//2
        mid_y = size[1]//2
        d = math.sqrt(((mid_x-self.x)**2)+((mid_y-self.y)**2))
        if d > 0:
            self.dx += float(self.center(d,self.task)) * (mid_x-self.x) / d
            self.dy += float(self.center(d,self.task)) * (mid_y-self.y) / d
####            if self.task == 1 and self.enemyFound:
##                print self.center(d,self.task),float(self.center(d,self.task))*(mid_x-self.x)/d
##                print self.center(d,self.task),float(self.center(d,self.task))*(mid_y-self.y)/d

        # Enemy Sensor
        enemySeen = False
        sensor_range = 50
        closest_e = sensor_range
        for ei in e.e:
            d = math.sqrt(((ei.x-self.x)**2)+((ei.y-self.y)**2))
            if d < sensor_range and d > 0:
                if  self.task == 1:# or self.task == 0:
                    if ei.found == False:
                        s.enemies_found += 1
                        ei.found = True
                    if not botKnows:
                        self.enemyFound = True
                        self.enemyX = ei.x
                        self.enemyY = ei.y
                    enemySeen = True
                if d < closest_e:
                    closest_e = d
                    x2 = ei.x
                    y2 = ei.y
            if d <= ei.r+5 and self.task == 1:
                s.kills += self.detonate(s,e,t,True)
##                    self.attack_enemy(ei)
        if enemySeen and self.task == 1:
            (to,pl) = self.enemy_wt(closest_e,self.task,sensor_range)
##            pygame.draw.line(screen,orange,[self.x,self.y],[x2,y2])
            self.dx += float(to) * (x2-self.x) / closest_e
            self.dy += float(to) * (y2-self.y) / closest_e
            self.dx += float(pl) * (y2-self.y) / closest_e
            self.dy -= float(pl) * (x2-self.x) / closest_e
        if self.task == 1:# or self.task == 0:
            if self.enemyFound:
                d2enemy = math.sqrt(((self.enemyX-self.x)**2)+((self.enemyY-self.y)**2))
                (to,pl) = self.group(botsSeenSame,6)
                self.dx += float(to) * (self.enemyX-self.x) / d2enemy
                self.dy += float(to) * (self.enemyY-self.y) / d2enemy
                self.dx += float(pl) * (self.enemyY-self.y) / d2enemy
                self.dy -= float(pl) * (self.enemyX-self.x) / d2enemy

        if botKnows and self.task == 1:
            (to,pl) = self.bot_knows(closestBotKnows,50)
            self.dx += float(to) * (botKnowsX-self.x) / closestBotKnows
            self.dy += float(to) * (botKnowsY-self.y) / closestBotKnows
            self.dx += float(pl) * (botKnowsY-self.y) / closestBotKnows
            self.dy -= float(pl) * (botKnowsX-self.x) / closestBotKnows
                

        # Torpedo Sensor
        torpedoSeen = False
        sensor_range = 40
        closest_t = sensor_range
        for ti in e.t:
            d = math.sqrt(((ti.x-self.x)**2)+((ti.y-self.y)**2))
            if d < sensor_range and d > 0:
                if self.task == 0:
                    torpedoSeen = True
##                torpedoSeen = True
                if d < closest_t:
                    closest_t = d
                    x = ti.x
                    y = ti.y
            if d <= self.r + 8 and self.task == 0:
                self.detonate(s,e,t,False)
##                    self.attack_torpedo(ti)
        torpedo_wt = 4
        if torpedoSeen and self.task == 0:
            (to,pl) = self.torpedo_wt(closest_t,self.task,sensor_range)
##                pygame.draw.line(screen,red,[self.x,self.y],[x,y])
            self.dx += float(to) * (x-self.x) / closest_t
            self.dy += float(to) * (y-self.y) / closest_t
            self.dx += float(pl) * (y-self.y) / closest_t
            self.dy -= float(pl) * (x-self.x) / closest_t

        self.signal = False
        difference = botsSeenSame - botsSeenDif
        difference = float(difference)
        if self.task == 1 and targetSeen and not self.enemyFound and not botKnows: # Switch if there aren't enough units defending the target
            help = float(t.help)
            threshold = float(self.w[57])
            prob_switch = 1-((help**4)/((help**4)+(threshold**4)))
            x = random.uniform(0,1)
            if x < prob_switch:
                self.task = 0 
        elif difference > 0 and not self.enemyFound: # Check if the bot  is bored (too many units of same type)
            t = float(self.w[61+self.task])
            prob_switch = ((difference**4)/((difference**4)+(t**4)))
            x = random.uniform(0,1)
            if x < prob_switch:
                self.task = (self.task + 1)%2
##                print "bored"
        elif self.signal_heard and not self.enemyFound and not torpedoSeen: # Then check if there are any distress signals heard
##            print "heard help...switching...", self.enemyFound, self.task
            self.task = (self.task + 1)%2
        elif botsSeenDif > 0 and (self.enemyFound or torpedoSeen): # Then check if the bot needs to ask for help
            t = float(self.w[58+self.task])
            botsSeenSame += 1
            prob_help = (1-((botsSeenSame**4)/((botsSeenSame**4)+(t**4))))
            x = random.uniform(0,1)
            if x < prob_help:
##                print "Asking for help...",self.task,self.enemyFound
                self.signal = True
##        elif self.recruiting == True and self.task == 0:
##            self.signal = True
##        elif self.task == 1 and 
        if self.task == 1 and self.enemyFound:
            d2enemy = math.sqrt(((self.enemyX-self.x)**2)+((self.enemyY-self.y)**2))
            if d2enemy < 40 and not enemySeen:
                self.enemyFound = False
##        if self.task == 1 and targetSeen and botsSeenDif == 0:
##            self.task = 0

##        if self.task == 1 and self.enemyFound:
##            print self.dx, self.dy

        max_speed = 5
        current_speed = math.sqrt((self.dx**2)+(self.dy**2))
        if current_speed > max_speed:
            self.dx = float(self.dx) / (current_speed) * max_speed
            self.dy = float(self.dy) / (current_speed) * max_speed

        dist = math.sqrt((self.dx**2)+(self.dy**2))
        s.dist += dist

        self.x += self.dx
        self.y += self.dy

##        if self.x > self.max_x - self.r:
##            self.x = self.max_x - self.r
##            self.dx *= -1
##        elif self.x < self.r:
##            self.x = self.r
##            self.dx *= -1
##        if self.y > self.max_y - self.r:
##            self.y = self.max_y -self.r
##            self.dy *= -1
##        elif self.y < self.r:
##            self.y = self.r
##            self.dy *= -1

##        self.previousX[2] = self.previousX[1]
##        self.previousX[1] = self.previousX[0]
##        self.previousX[0] = self.x
##        self.previousY[2] = self.previousY[1]
##        self.previousY[1] = self.previousY[0]
##        self.previousY[0] = self.y

    def attack_enemy(self,e):

        if e.d > 0:
            e.d -= 1
        else:
            e.h -= float(random.randint(0,self.h)+5)/10
            if e.h < 0:
                e.h = 0
        self.h -= float(random.randint(0,10))
        if self.h < 0:
            self.h = 0

    def attack_torpedo(self,t):

        t.h -= float(random.randint(0,self.h)+5)/10
        if t.h < 0:
            t.h = 0
        self.h -= random.randint(0,1)
        

    def detonate(self,swarm,enemies,target,attacking):
        x = self.x
        y = self.y
        r = self.r
        color = red
        kills = 0
        if attacking:
            blast_radius = 0
            attack_radius = 20
##            count = 0
##            for b in swarm.bots:
##                d = math.sqrt((b.x-x)**2+(b.y-y)**2)
        else:
            blast_radius = 20
            attack_radius = 20
##        kills = 0
        deadBots = []
        for n, b in enumerate(swarm.bots):
            d = math.sqrt((b.x-x)**2+(b.y-y)**2)
            if d <= (blast_radius):
                deadBots.append(n)
                swarm.size -= 1
        deadEnemies = []
        for n, e in enumerate(enemies.e):
            d = math.sqrt((e.x-x)**2+(e.y-y)**2)
            if d < (attack_radius):
                if e.d > 0:
                    e.d -= 1
                    color = (0,191,255)
                else:
                    e.h -= 100
##                    print e.h
                if e.h <= 0:
                    deadEnemies.append(n)
                    enemies.size -= 1
                    kills += 1
##                deadEnemies.append(n)
##                enemies.size -= 1
##                kills += 1
        d = math.sqrt((target.x-x)**2+(target.y-y)**2)
        if d < (blast_radius):
            target.health -= 100
        deadTorpedos = []
        for n, t in enumerate(enemies.t):
            d = math.sqrt((t.x-x)**2+(t.y-y)**2)
            if d < (blast_radius):
                deadTorpedos.append(n)
##                enemies.size -= 1
        for i in deadBots[::-1]:
            del swarm.bots[i]
        for i in deadEnemies[::-1]:
            del enemies.e[i]
        for i in deadTorpedos[::-1]:
            del enemies.t[i]
##        pygame.draw.circle(screen,color,[int(x),int(y)],r+40)
        return kills

    def draw(self,screen):
        if self.task == 1 and not self.enemyFound:
            pygame.draw.circle(screen,red,[int(self.x),int(self.y)],self.r)
        elif self.task == 1 and self.enemyFound:
            pygame.draw.circle(screen,pink,[int(self.x),int(self.y)],self.r)
        else:
            pygame.draw.circle(screen,white,[int(self.x),int(self.y)],self.r)



class Enemies_obj:

    def __init__(self):
        self.wait = 50 #random.randint(50,100)
        self.e = []
        self.t = []
        self.size = 0

    def update(self,objects):
        self.wait -= 1
        if self.wait <= 0:
            self.wait = 600 #random.randint(300,200)
            self.spawn()
            self.size += 1
        for e in self.e:
            fire,pos = e.update(objects)
            if fire:
                self.t.append(T_obj(pos))
        for t in self.t:
            t.update(objects)

    def draw(self,screen):

        for e in self.e:
            e.draw(screen)
        for t in self.t:
            t.draw(screen)

    def check_deaths(self):
        len_e = len(self.e)
        for n, e in enumerate(reversed(self.e)):
            if e.h <= 0:
                del self.e[len_e-n-1]
        len_t = len(self.t)
        for n, t in enumerate(reversed(self.t)):
            if t.h <= 0:
                del self.t[len_t-n-1]

    def spawn(self):
        self.e.append(Enemy_obj())

class T_obj:

    def __init__(self,pos):
        self.x,self.y = pos
        self.r = 4
        self.h = 20

    def update(self,objects):
        (s,e,t) = objects
        dx = t.x - self.x
        dy = t.y - self.y
        dx += random.randint(0,1) + random.randint(-1,0)
        dy += random.randint(-1,0) + random.randint(0,1)
        d = math.sqrt(dx**2+dy**2)
        speed = 4
        dx = dx*speed/d
        dy = dy*speed/d
        self.x += dx
        self.y += dy
        if d < t.r:
           t.health -= 100
           self.h = -1

    def draw(self,screen):
        pygame.draw.circle(screen,(0,200,0),[int(self.x),int(self.y)],self.r)

class Enemy_obj:

    def __init__(self):
        x = size[0]
        y = size[1]
        self.r = 10
        self.d = 0
        self.h = 201
        self.wait = 50 #random.randint(50,100)
        side = random.randint(0,4)
##        if side == 0: # Top
##            self.x = random.randint(0,x)
##            self.y = 0
##        elif side == 1: # Right
##            self.x = x
##            self.y = random.randint(0,y)
##        elif side == 2: # Bottom
##            self.x = random.randint(0,x)
##            self.y = y
##        else: # Left
##            self.x = 0
##            self.y = random.randint(0,y)
        angle = random.uniform(0,math.pi * 2)
        self.x = int((size[0]/float(2))*math.cos(angle))
        self.y = int((size[1]/float(2))*math.sin(angle))
        self.x += int(size[0]/float(2))
        self.y += int(size[1]/float(2))
##        print angle, self.x, self.y
        self.dx = 0
        self.dy = 0
        self.found = False

    def update(self,objects):
        self.d = 0
        self.wait -= 1
        if self.wait <= 0:
            fire = True
            self.wait = random.randint(100,200)
        else:
            fire = False
        if self.h < 201:
            self.h += 1
        (s,e,t) = objects
        self.x_d = t.x - self.x
        self.y_d = t.y - self.y
        d = math.sqrt(self.x_d**2+self.y_d**2)
        speed = 1
        self.dx += random.randint(-1,0) + random.randint(0,1)
        self.dy += random.randint(-1,0) + random.randint(0,1)
        d2 = math.sqrt(self.dx**2+self.dy**2)
        if d2 > 0:
            self.dx = self.dx * speed / d2
            self.dy = self.dy * speed / d2
        self.x += self.dx
        self.y += self.dy

        if self.x < 0:
            self.x = 0
            self.dx *= -1
        elif self.x > size[0]:
            self.x = size[0]
            self.dx *= -1
        if self.y < 0:
            self.y = 0
            self.dy *= -1
        elif self.y > size[1]:
            self.y = size[1]
            self.dy *= -1

        if d < 500:
            if self.y < t.y:
                if self.x==t.x:
                    theta = -math.pi/2
                elif self.x<t.x:
                    theta = math.atan((self.y-t.y)/(self.x-t.x))-math.pi
                else:
                    theta = math.atan((self.y-t.y)/(self.x-t.x))
            elif self.y > t.y:
                if self.x==t.x:
                    theta = math.pi/2
                elif self.x<t.x:
                    theta = math.atan((self.y-t.y)/(self.x-t.x))+math.pi
                else:
                    theta = math.atan((self.y-t.y)/(self.x-t.x))
            else:
                if self.x<t.x:
                    theta = math.pi
                else:
                    theta = 0
            self.x += ((500-d)*math.cos(theta))
            self.y += ((500-d)*math.sin(theta))
        pos = (self.x,self.y)
        return fire, pos

##        if d < t.r:
##            self.attack(t)

    def attack(self,t):
        
        t.health -= random.randint(0,1)
        if t.health < 0:
            t.health = 0

    def draw(self,screen):
        if self.found:
            pygame.draw.circle(screen,orange,[int(self.x),int(self.y)],self.r)
        else:
            pygame.draw.circle(screen,yellow,[int(self.x),int(self.y)],self.r)

class Target_obj:

    def __init__(self):
        self.r = 15
        self.x = size[0] / 2
        self.y = size[1] / 2
        self.health = 1000

    def count(self,s):
        self.help = 0.0
        for b in s.bots:
            d = math.sqrt(((b.x-self.x)**2.0)+((b.y-self.y)**2.0))
            if d < 100 and b.task == 0:
                self.help += 1

    def draw(self,screen):
        if self.health <= 0:
            self.health = 0
        blue = 0,0,int(255 * (float(self.health) / 1000))
        pygame.draw.circle(screen,blue,[self.x,self.y],self.r)

        
